
/*-------------------------------------------------------------------------*
 *                                                                         *
 *  SCP2ASC.H                       Hauptprogramm : SCP2ASC                *
 *                                                                         *
 *  Convert SCP to ASC File                                                *
 *                                                                         *
 *-------------------------------------------------------------------------*
 *                                                                         *
 *  (C) 1992-96 by Firma Ingrid Schmidt / Frankfurt / Germany              *
 *  Written 1992/93 by Andreas Claus Schmidt                               *
 *                                                                         *
 *-------------------------------------------------------------------------*
 *                                                                         *
 *  Version 1.0                                                            *
 *                                                                         *
 *  Alle Rechte vorbehalten, auch die der fotomechanischen Wiedergabe und  *
 *  der Speicherung in elektronischen Medien.                              *
 *  Die Nutzung der in diesem Programm gezeigten Modelle und Arbeiten ist  *
 *  nicht zulssig.                                                        *
 *  Fehler in Programmen knnen nicht vollstndig ausgeschlossen werden.   *
 *  Die Firma und sie Autor knnen fr fehlerhafte Programme und deren     *
 *  Folgen weder eine juristische Verantwortung noch irgendeine Haftung    *
 *  bernehmen.                                                            *
 *                                                                         *
 *-------------------------------------------------------------------------*/

    #include <stdio.h>
    #include <stdlib.h>

    struct channeldef
       {
       unsigned char kanal   ;
       unsigned char belegt     ;
       unsigned char darstellen ;
       unsigned char eingelesen ;
       unsigned char calc       ;
       unsigned char dots     ; 
       double        volt     ;
       unsigned char offset   ;
       unsigned char color ;
       unsigned char array[4096];
       };

    struct datendef
       {
       unsigned char scope;
       unsigned char pretrigger;
       double        zeit;
       unsigned char parameterblock[256];
       unsigned char triggerlevel[20];
       unsigned long time     ;
       unsigned long date     ;
       unsigned int  maximal  ;
       unsigned char dots     ;
       unsigned char xy       ;
       unsigned char raster   ;
       unsigned char dot_join ;
       unsigned char split    ;
       unsigned char mode     ;
       unsigned char aktiv    ;
       unsigned char passiv   ;
       unsigned char curs[2]  ;
       unsigned char comment[48];
       int           fenster1 ;
       int           fenster2 ;
       int           pos[2]   ;
       };
       
    struct indexdatei
       {
       unsigned char ind[3];
       unsigned char firmenname[40];
       unsigned char username[40];
       unsigned int  freischaltung;
       unsigned long seriennummer;
       unsigned long datum;
       unsigned long zeit;
       unsigned char leer[12];
       unsigned char addition;
       unsigned int  checksumme;
       };
       
/*-----------------------------------------------------------------------*/

    struct channeldef  channel[8];
    struct channeldef  *pchannel;
    struct datendef    daten;
    struct datendef    *pdaten;
    struct indexdatei  index;
